from sympy import symbols, integrate, log
from sympy.stats import Uniform, density
from math import exp

# Define the variable and the uniform distribution
u = symbols('u')
U = Uniform('U', 0, 1)

# Define the probability density function of U
f_U = density(U)(u)

# Define r
r = symbols('r', positive=True)

# Define the condition
condition = r >= -log(u)

# Integrate the probability density function over the range where the condition is satisfied
probability = integrate(f_U, (u, 0, exp(-r)))

probability.simplify()
